using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using ZylIdleTimer;

namespace TimerResolutionDemo
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnStart;
		private System.Windows.Forms.Button btnStop;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.TextBox textBoxOut;
		private System.Windows.Forms.Timer timerStandard;
		private System.Windows.Forms.Label lblIdleTime;
		private ZylIdleTimer.IdleTimer idleTimer;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//		
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.textBoxOut = new System.Windows.Forms.TextBox();
			this.btnStart = new System.Windows.Forms.Button();
			this.btnStop = new System.Windows.Forms.Button();
			this.timerStandard = new System.Windows.Forms.Timer(this.components);
			this.lblIdleTime = new System.Windows.Forms.Label();
			this.idleTimer = new ZylIdleTimer.IdleTimer(this.components);
			this.SuspendLayout();
			// 
			// textBoxOut
			// 
			this.textBoxOut.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBoxOut.Location = new System.Drawing.Point(16, 16);
			this.textBoxOut.Multiline = true;
			this.textBoxOut.Name = "textBoxOut";
			this.textBoxOut.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBoxOut.Size = new System.Drawing.Size(264, 144);
			this.textBoxOut.TabIndex = 0;
			this.textBoxOut.Text = "";
			// 
			// btnStart
			// 
			this.btnStart.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.btnStart.Location = new System.Drawing.Point(31, 208);
			this.btnStart.Name = "btnStart";
			this.btnStart.TabIndex = 1;
			this.btnStart.Text = "Start";
			this.btnStart.Click += new System.EventHandler(this.btnStart_Click);
			// 
			// btnStop
			// 
			this.btnStop.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.btnStop.Location = new System.Drawing.Point(184, 208);
			this.btnStop.Name = "btnStop";
			this.btnStop.TabIndex = 2;
			this.btnStop.Text = "Stop";
			this.btnStop.Click += new System.EventHandler(this.btnStop_Click);
			// 
			// timerStandard
			// 
			this.timerStandard.Interval = 200;
			this.timerStandard.Tick += new System.EventHandler(this.timerStandard_Tick);
			// 
			// lblIdleTime
			// 
			this.lblIdleTime.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblIdleTime.AutoSize = true;
			this.lblIdleTime.Location = new System.Drawing.Point(16, 176);
			this.lblIdleTime.Name = "lblIdleTime";
			this.lblIdleTime.Size = new System.Drawing.Size(57, 16);
			this.lblIdleTime.TabIndex = 3;
			this.lblIdleTime.Text = "Idle Time: ";
			// 
			// idleTimer
			// 
			this.idleTimer.Enabled = false;
			this.idleTimer.SystemInterval = 3000;
			this.idleTimer.SystemResume += new ZylIdleTimer.ResumeEventHandler(this.idleTimer_SystemResume);
			this.idleTimer.SystemIdle += new ZylIdleTimer.IdleEventHandler(this.idleTimer_SystemIdle);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(296, 238);
			this.Controls.Add(this.lblIdleTime);
			this.Controls.Add(this.textBoxOut);
			this.Controls.Add(this.btnStop);
			this.Controls.Add(this.btnStart);
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "ZylIdleTimer.NET Demo";
			this.Closed += new System.EventHandler(this.Form1_Closed);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnStart_Click(object sender, System.EventArgs e)
		{
			timerStandard.Enabled = true;
			idleTimer.Enabled = true;
		}

		private void btnStop_Click(object sender, System.EventArgs e)
		{
			timerStandard.Enabled = false;
			idleTimer.Enabled = false;
		}	
	

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			if (idleTimer != null)
			{
				idleTimer.Enabled = false;
				timerStandard.Enabled = false;
			}
		}

		private void timerStandard_Tick(object sender, System.EventArgs e)
		{
			lblIdleTime.Text = "Idle Time(ms): " + IdleTimer.GetSystemIdleTime().ToString();
		}

		private void idleTimer_SystemIdle(object sender, System.EventArgs e)
		{
			textBoxOut.Text +=  DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + ":"  +
				DateTime.Now.Second.ToString() + ":" +  DateTime.Now.Millisecond.ToString() +
				" - Idle Fired." + Environment.NewLine;
			textBoxOut.SelectionStart = textBoxOut.Text.Length;
			textBoxOut.SelectionLength = 0;
			textBoxOut.ScrollToCaret();		
		}

		private void idleTimer_SystemResume(object sender, System.EventArgs e)
		{
			textBoxOut.Text +=  DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + ":"  +
				DateTime.Now.Second.ToString() + ":" +  DateTime.Now.Millisecond.ToString() +
				" - Resume Fired." + Environment.NewLine;
			textBoxOut.SelectionStart = textBoxOut.Text.Length;
			textBoxOut.SelectionLength = 0;
			textBoxOut.ScrollToCaret();		
		}
	}
}
